<?php

class Element_Ultimate_AI_Login_Register_Form extends \Elementor\Widget_Base
{
  public function get_name()
  {
    return 'element_ultimate_ai_login_register_form';
  }

  public function get_title()
  {
    return esc_html__('Login/Register Form', ULTIMATE_AI_SLUG);
  }

  public function get_icon()
  {
    return 'eicon-lock-user';
  }

  public function get_categories()
  {
    return ['ultimate_ai_catetory'];
  }

  public function get_script_depends()
  {
    return ["element_ultimate_ai_login_register_form"];
  }

  public function get_style_depends()
  {
    return [];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'register_form_title_desc_section',
      [
        'label' => esc_html__('Form', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'login_form_title',
      [
        'label' => esc_html__('Login form title', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Welcome back', ULTIMATE_AI_SLUG),
        'placeholder' => esc_html__('Type your title here', ULTIMATE_AI_SLUG),
      ]
    );

    $this->add_control(
      'login_form_desc',
      [
        'label' => esc_html__('Login form desc', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => esc_html__('Default description', ULTIMATE_AI_SLUG),
        'placeholder' => esc_html__('Type your description here', ULTIMATE_AI_SLUG),
      ]
    );

    $this->add_control(
      'signin_form_title',
      [
        'label' => esc_html__('Register form title', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Register', ULTIMATE_AI_SLUG),
        'placeholder' => esc_html__('Type your title here', ULTIMATE_AI_SLUG),
      ]
    );

    $this->add_control(
      'signin_form_desc',
      [
        'label' => esc_html__('Register form desc', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => esc_html__('Default description', ULTIMATE_AI_SLUG),
        'placeholder' => esc_html__('Type your description here', ULTIMATE_AI_SLUG),
      ]
    );

    $this->add_control(
      'form_redirect_url',
      [
        'label' => esc_html__('Redirect url', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::URL,
        'options' => ['url'],
        'default' => [
          'url' => '',
        ],
        'label_block' => true,
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'form_heading',
      [
        'label' => esc_html__('Form heading', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'form_heading_alignment',
      [
        'label' => esc_html__('Title and Desc alignment', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'left',
        'options' => [
          'left' => esc_html__('Left', ULTIMATE_AI_SLUG),
          'center'  => esc_html__('Center', ULTIMATE_AI_SLUG),
          'right'  => esc_html__('Right', ULTIMATE_AI_SLUG),
        ],
        'selectors' => [
          '{{WRAPPER}} .element_uai_login_con h3' => 'text-align: {{VALUE}};',
          '{{WRAPPER}} .element_uai_login_con p' => 'text-align: {{VALUE}};',
          '{{WRAPPER}} .element_uai_register_con h3' => 'text-align: {{VALUE}};',
          '{{WRAPPER}} .element_uai_register_con p' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'label' => esc_html__('Login title typography', ULTIMATE_AI_SLUG),
        'name' => 'login_title_typography',
        'selector' => '{{WRAPPER}} .element_uai_login_con h3',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'label' => esc_html__('Login desc typography', ULTIMATE_AI_SLUG),
        'name' => 'login_desc_typography',
        'selector' => '{{WRAPPER}} .element_uai_login_con p',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'label' => esc_html__('Register title typography', ULTIMATE_AI_SLUG),
        'name' => 'signin_title_typography',
        'selector' => '{{WRAPPER}} .element_uai_register_con h3',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'label' => esc_html__('Register desc typography', ULTIMATE_AI_SLUG),
        'name' => 'signin_desc_typography',
        'selector' => '{{WRAPPER}} .element_uai_register_con p',
      ]
    );

    $this->add_responsive_control(
      'login_form_title_color',
      [
        'label' => esc_html__('Login form title color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .element_uai_login_con h3' => 'color:{{VALUE}}'
        ],
      ]
    );
    $this->add_responsive_control(
      'login_form_desc_color',
      [
        'label' => esc_html__('Login form desc color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .element_uai_login_con p' => 'color:{{VALUE}}'
        ],
      ]
    );
    $this->add_responsive_control(
      'signin_form_title_color',
      [
        'label' => esc_html__('Register form title color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .element_uai_register_con h3' => 'color:{{VALUE}}'
        ],
      ]
    );
    $this->add_responsive_control(
      'signin_form_desc_color',
      [
        'label' => esc_html__('Register form desc color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .element_uai_register_con p' => 'color:{{VALUE}}'
        ],
      ]
    );

    //loop and add controll
    $_fields = [
      ["login_title_spacing", "Login title spacing", "{{WRAPPER}} .element_uai_login_con h3"],
      ["login_desc_spacing", "Login desc spacing", "{{WRAPPER}} .element_uai_login_con p"],
      ["signin_title_spacing", "Register title spacing", "{{WRAPPER}} .element_uai_register_con h3"],
      ["signin_desc_spacing", "Register desc spacing", "{{WRAPPER}} .element_uai_register_con p"],
    ];

    foreach ($_fields as $_field) {
      $this->add_control(
        $_field[0],
        [
          'label' => esc_html__($_field[1], ULTIMATE_AI_SLUG),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => ['px', '%', 'em', 'rem', 'custom'],
          'default' => [
            'top' => 0,
            'right' => 0,
            'bottom' => 0,
            'left' => 0,
            'unit' => 'px',
            'isLinked' => false,
          ],
          'selectors' => [
            $_field[2] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
    } //loop end


    $this->end_controls_section();



    $this->start_controls_section(
      'register_form_box_section',
      [
        'label' => esc_html__('Form', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'register_form_fields_spaceing',
      [
        'type' => \Elementor\Controls_Manager::SLIDER,
        'label' => esc_html__('Field spacing', ULTIMATE_AI_SLUG),
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 200,
          ],
        ],
        'devices' => ['desktop', 'tablet', 'mobile'],
        'desktop_default' => [
          'size' => 20,
          'unit' => 'px',
        ],
        'tablet_default' => [
          'size' => 20,
          'unit' => 'px',
        ],
        'mobile_default' => [
          'size' => 10,
          'unit' => 'px',
        ],
        'selectors' => [
          '{{WRAPPER}} .register_account_form div.form > div' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
        ],
      ]
    );

    $this->add_responsive_control(
      'register_form_fields_height',
      [
        'type' => \Elementor\Controls_Manager::SLIDER,
        'label' => esc_html__('Input field height', ULTIMATE_AI_SLUG),
        'range' => [
          'px' => [
            'min' => 40,
            'max' => 100,
          ],
        ],
        'devices' => ['desktop', 'tablet', 'mobile'],
        'desktop_default' => [
          'size' => 40,
          'unit' => 'px',
        ],
        'tablet_default' => [
          'size' => 40,
          'unit' => 'px',
        ],
        'mobile_default' => [
          'size' => 40,
          'unit' => 'px',
        ],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .text_input input' => 'height: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} #ultimate-ai-root .input_password input' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'register_form_fields_padding',
      [
        'label' => esc_html__('Input field padding', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .text_input input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} #ultimate-ai-root .input_password input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );


    $this->add_responsive_control(
      'register_form_fields_border_radius',
      [
        'label' => esc_html__('Input fields border radius', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .text_input input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} #ultimate-ai-root .input_password input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form button.register_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'register_form_input_bg_color',
      [
        'label' => esc_html__('background color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .text_input input' => 'background: {{VALUE}}',
          '{{WRAPPER}} #ultimate-ai-root .input_password input' => 'background: {{VALUE}}',
        ],
      ]
    );


    $this->end_controls_section();


    $this->start_controls_section(
      'register_form_content_section',
      [
        'label' => esc_html__('Content', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'register_form_label_typography',
        'selector' => '{{WRAPPER}} .register_account_form .text_input p.tools_label, {{WRAPPER}} .register_account_form .input_password p.tools_label',
        'label' => esc_html__('Input label typography', ULTIMATE_AI_SLUG),
      ]
    );
    $this->add_responsive_control(
      'register_form_label_color',
      [
        'label' => esc_html__('Label color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .register_account_form .text_input p.tools_label' => 'color: {{VALUE}}',
          '{{WRAPPER}} .register_account_form .input_password p.tools_label' => 'color: {{VALUE}}',
        ],
      ]
    );


    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'register_form_input_typography',
        'selector' => '{{WRAPPER}} #ultimate-ai-root .text_input input, {{WRAPPER}} #ultimate-ai-root .input_password input',
        'label' => esc_html__('Input typography', ULTIMATE_AI_SLUG),
      ]
    );
    $this->add_responsive_control(
      'register_form_input_color',
      [
        'label' => esc_html__('Input color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .text_input input' => 'color: {{VALUE}}',
          '{{WRAPPER}} #ultimate-ai-root .input_password input' => 'color: {{VALUE}}',
        ],
      ]
    );


    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'register_form_input_placeholder_typography',
        'selector' => '{{WRAPPER}} #ultimate-ai-root .text_input input::placeholder, {{WRAPPER}} #ultimate-ai-root .input_password input::placeholder',
        'label' => esc_html__('Input placeholder typography', ULTIMATE_AI_SLUG),
      ]
    );
    $this->add_responsive_control(
      'register_form_input_placeholder_color',
      [
        'label' => esc_html__('Input placeholder color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .text_input input::placeholder' => 'color: {{VALUE}}',
          '{{WRAPPER}} #ultimate-ai-root .input_password input::placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );


    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'register_form_policy_typography',
        'selector' => '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form > div.policy p',
        'label' => esc_html__('Policy typography', ULTIMATE_AI_SLUG),
      ]
    );
    $this->add_responsive_control(
      'register_form_policy_color',
      [
        'label' => esc_html__('Policy color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form > div.policy p' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();


    $this->start_controls_section(
      'register_form_button_section',
      [
        'label' => esc_html__('Button', ULTIMATE_AI_SLUG),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'register_form_submit_btn_typography',
        'selector' => '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form button.register_btn',
        'label' => esc_html__('Typography', ULTIMATE_AI_SLUG),
      ]
    );
    $this->add_responsive_control(
      'register_form_submit_btn_color',
      [
        'label' => esc_html__('Text color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form button.register_btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'register_form_submit_btn_bgcolor',
      [
        'label' => esc_html__('Background color', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form button.register_btn:enabled' => 'background-color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'register_form_button_border_radius',
      [
        'label' => esc_html__('Border radius', ULTIMATE_AI_SLUG),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors' => [
          '{{WRAPPER}} #ultimate-ai-root .register_account_form div.form button.register_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();
?>
    <div id="ultimate-ai-root">
      <style>
        .element_uai_register_con.hide,
        .element_uai_login_con.hide {
          display: none;
        }

        .element_uai_register_con.show,
        .element_uai_register_con.show {
          display: unset;
        }
      </style>

      <div class="element_uai_login_register_form_container">
        <div class="element_uai_login_con hide">
          <h3><?php echo $settings["login_form_title"]; ?></h3>
          <p><?php echo $settings["login_form_desc"]; ?></p>
        </div>
        <div class="element_uai_register_con hide">
          <h3><?php echo $settings["signin_form_title"]; ?></h3>
          <p><?php echo $settings["signin_form_desc"]; ?></p>
        </div>
        <div id="element_ultimate_ai_login_register_form"></div>
      </div>
    </div>
    <script>
      window.uai_redirect_form_url = "<?php echo $settings["form_redirect_url"]["url"] ?? "" ?>";
      window.Element_Ultimate_AI_Login_Register_Form_RUN?.(window.uai_redirect_form_url);
    </script>
<?php
  }
}
